<?
	include("rrd-smart.inc");

	define("RRD_STEP"     , 300);				// 300sec
	define("HEARTBEAT"    , 1800);
	define("RRA_MIN_KEEP" , 365*24*60*60);		// 1 year
	define("RRA_MAX_KEEP" , 365*24*60*60);		// 1 year
	define("RRA_AVE_KEEP" , 365*24*60*60);		// 1 year
	define("RRA_LAST_KEEP", 2*365*24*60*60);	// 2 year
	define("GRAPH_WIDTH"  , 520);
	define("GRAPH_HEIGHT" , 240);

	define("V_RAW", 0x001);	// RAW value
	define("V_VAL", 0x002);	// Normalized value
	$smart_vals = array(
	  V_VAL=>"VAL",
	  V_RAW=>"RAW",
	);
	define("G_NONE"  , ""      );
	define("G_TEMP"  , "temp"  );
	define("G_SECTOR", "sector");
	define("G_ERROR" , "error" );
	define("G_INFO"  , "info"  );
	define("G_SEEK"  , "seek"  );
	$smart_groups = array(
		G_TEMP   => array("GROUP"=>G_TEMP  , LABEL=>"Temperature"),
		G_SECTOR => array("GROUP"=>G_SECTOR, LABEL=>"Sector Read/Write"),
		G_ERROR  => array("GROUP"=>G_ERROR , LABEL=>"Error/Warning"),
		G_INFO   => array("GROUP"=>G_INFO  , LABEL=>"Information"),
		G_SEEK   => array("GROUP"=>G_SEEK  , LABEL=>"Seek/Spin"),
	);

	$smart_tbl = array(
		array("ID"=>  1,"LABEL"=>"Raw_Read_Error_Rate    ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_ERROR ),
		array("ID"=>  2,"LABEL"=>"Throughput_Performance ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>  3,"LABEL"=>"Spin_Up_Time           ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
		array("ID"=>  4,"LABEL"=>"Start_Stop_Count       ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>  5,"LABEL"=>"Reallocated_Sector_Ct  ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SECTOR),
		array("ID"=>  7,"LABEL"=>"Seek_Error_Rate        ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
		array("ID"=>  8,"LABEL"=>"Seek_Time_Performance  ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
		array("ID"=>  9,"LABEL"=>"Power_On_Hours         ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=> 10,"LABEL"=>"Spin_Retry_Count       ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
		array("ID"=> 11,"LABEL"=>"Calibration_Retry_Count","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
		array("ID"=> 12,"LABEL"=>"Power_Cycle_Count      ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>192,"LABEL"=>"Power-Off_Retract_Count","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>193,"LABEL"=>"Load_Cycle_Count       ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>194,"LABEL"=>"Temperature_Celsius    ","VAL"=>V_RAW,TYPE=>"GAUGE","GROUP"=>G_TEMP  ),
		array("ID"=>195,"LABEL"=>"Hardware_ECC_Recovered ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_ERROR ),
		array("ID"=>196,"LABEL"=>"Reallocated_Event_Count","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SECTOR),
		array("ID"=>197,"LABEL"=>"Current_Pending_Sector ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SECTOR),
		array("ID"=>198,"LABEL"=>"Offline_Uncorrectable  ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SECTOR),
		array("ID"=>199,"LABEL"=>"UDMA_CRC_Error_Count   ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_ERROR ),
		array("ID"=>200,"LABEL"=>"Multi_Zone_Error_Rate  ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_ERROR ),
		array("ID"=>201,"LABEL"=>"Soft_Read_Error_Rate   ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_ERROR ),
		array("ID"=>202,"LABEL"=>"TA_Increase_Count      ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_NONE  ),
		array("ID"=>203,"LABEL"=>"Run_Out_Cancel         ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>204,"LABEL"=>"Shock_Count_Write_Opern","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>205,"LABEL"=>"Shock_Rate_Write_Opern ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>207,"LABEL"=>"Spin_High_Current      ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_INFO  ),
		array("ID"=>208,"LABEL"=>"Spin_Buzz              ","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_NONE  ),
		array("ID"=>209,"LABEL"=>"Offline_Seek_Performnce","VAL"=>V_VAL,TYPE=>"GAUGE","GROUP"=>G_SEEK  ),
	);

	$mode = "";
	$ac = count($_SERVER["argv"]);
	$av = $_SERVER["argv"];
	for ( $i = 1; $i < $ac; $i++ )
	{
		$s = $av[$i];
		if ( substr($s, 0, 1) == "-" )
		{	// option
			if ( $s == "-hostname" && $i + 1 < $ac )
			{
				$i++;
				$hostname = $av[$i];
			} else if ( $s == "-device" && $i + 1 < $ac )
			{
				$i++;
				$opt["DEV"] = $av[$i];
			} else if ( $s == "-id" && $i + 1 < $ac )
			{
				$i++;
				$opt["ID"] = $av[$i];
			} else if ( $s == "-val" )
			{
				$opt["VAL"] = V_VAL;
			} else if ( $s == "-raw" )
			{
				$opt["VAL"] = V_RAW;
			}
		} else if ( $mode == "" )
		{
			$mode = $s;
			if ( $mode == "graph" && $i + 1 < $ac )
			{
				$i++;
				$gtype = $av[$i];
			}
		}
	}

	if ( $mode == "" )
		$mode = "print";
	echo "mode = {$mode} \n";
	switch ( $mode )
	{
		case "create":
			create_rrd($opt);
			break;

		case "update":
			update_rrd($opt);
			break;

		case "graph":
			if ( $gtype == "" )
				$gtype = "day";
			echo "GRAPH $gtype \n";
			graph_rrd($opt, $gtype);
			break;

		case "html":
			print_html($opt);
			break;

		case "tune":
			tune_rrd($opt);
			break;

		default:
			usage();
			break;
	}
	exit;

function	usage()
{
	$prog = basename($_SERVER["argv"][0]);
	$msg = "{$prog} : [<command>] [<option>]\n"
	. "  <command>\n"
	. "    create      ... Create/Initialize S.M.A.R.T. database\n"
	. "    graph <type>... Generate graph image file\n"
	. "                    type = year/nonth/week/day/hour\n"
	. "    html        ... Generate HTML file\n"
	. "    update      ... Update S.M.A.R.T. status\n"
	. "    tune        ... Tune database\n"
	. "  <option>\n"
	. "    -device <dev> ... graph: device\n"
	. "    -id <id>      ... graph: S.M.A.R.T. status ID\n"
	. "    -val          ... graph: Normalized value\n"
	. "    -raw          ... graph: RAW value\n"
	;

	echo $msg;
}

function	GetRrdPath($dev)
{
	return RRDDIR . "/smart-{$dev["LABEL"]}.rrd";
}

function	GetGraphFileName($dev, $group, $gtype)
{
	return "smart-{$dev["LABEL"]}-{$gtype}-{$group}.gif";
}
function	GetGraphPath($dev, $group, $gtype)
{
	return GRAPHDIR . "/" . GetGraphFileName($dev, $group, $gtype);
}

//////////////////////////////////////////////////////////////////////////
//	CREATE
//////////////////////////////////////////////////////////////////////////

function	create_rrd($opt)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$tm = time();
	for ( $di = 0; $di < count($smart_devs); $di++ )
	{
		$dev = $smart_devs[$di];
		$param = GetRrdPath($dev) . " --start {$tm} --step ".RRD_STEP;
		for ( $si = 0; $si < count($smart_tbl); $si++ )
		{
			$smart = $smart_tbl[$si];
			$ks_v = array_keys($smart_vals);
			for ( $vi = 0; $vi < count($ks_v); $vi++ )
			{
				$vtype = $ks_v[$vi];
				$cmd = "DS:{$smart_vals[$vtype]}{$smart["ID"]}:{$smart["TYPE"]}:".HEARTBEAT.":U:U";
				$param .= " {$cmd}";
			}
		}
		$min_keep  = (int)(RRA_MIN_KEEP  / (RRD_STEP * 12));
		$max_keep  = (int)(RRA_MAX_KEEP  / (RRD_STEP * 12));
		$ave_keep  = (int)(RRA_AVE_KEEP  / (RRD_STEP * 12));
		$last_keep = (int)(RRA_LAST_KEEP / RRD_STEP);
		$param .= " RRA:MIN:0.1:12:{$min_keep} RRA:MAX:0.1:12:{$max_keep} RRA:AVERAGE:0.1:12:{$max_keep} RRA:LAST:0.1:1:{$last_keep}";

		$cmd = RRDTOOL . " create {$param}";
		echo "{$cmd} \n";
		system($cmd);
	}
	return;
}

//////////////////////////////////////////////////////////////////////////
//	UPDATE
//////////////////////////////////////////////////////////////////////////

function	update_rrd($opt)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$tm = time();
	for ( $di = 0; $di < count($smart_devs); $di++ )
	{
		$dev = $smart_devs[$di];
		unset($vtbl);
		$cmd = SMARTCTL . " -A {$dev["DEV"]}";
		echo $cmd . "\n";

		$id_found = FALSE;
		$handle = popen($cmd, "r");
		while ( ($s = fgets($handle)) != FALSE )
		{
		//	echo $s;
			if ( ($p = preg_split("/[\s\n]/", $s,-1,PREG_SPLIT_NO_EMPTY)) == FALSE || count($p) < 10 )
				continue;
			if ( $id_found == FALSE )
			{
				if ( $p[0] == "ID#" )
					$id_found = TRUE;
			} else
			{
				$id = (int) $p[0];
				unset($smart);
				for ( $i = 0; $i < count($smart_tbl); $i++ )
				{
					if ( $smart_tbl[$i]["ID"] == $id )
					{
						$smart = $smart_tbl[$i];
						break;
					}
				}
				if ( isset($smart) )
				{
				//	echo "Set {$smart["ID"]}\n";
					$vname = $vtbl["{$smart_vals[V_VAL]}{$smart["ID"]}"] = (int) $p[3];
					$vname = $vtbl["{$smart_vals[V_RAW]}{$smart["ID"]}"] = (int) $p[9];
				}
			}
		}
		pclose($handle);

		$param = GetRrdPath($dev) . " {$tm}";
		for ( $si = 0; $si < count($smart_tbl); $si++ )
		{
			$smart = $smart_tbl[$si];
			$ks_v = array_keys($smart_vals);
			for ( $vi = 0; $vi < count($ks_v); $vi++ )
			{
				$vtype = $ks_v[$vi];
				$vname = "{$smart_vals[$vtype]}{$smart["ID"]}";
				if ( ! isset($vtbl[$vname]) )
					$vtbl[$vname] = "U";
				$param .= ":{$vtbl[$vname]}";
			}
		}

		$cmd = RRDTOOL . " update " . $param;
		echo "{$cmd} \n";
		system($cmd);
	}
	return;
}

//////////////////////////////////////////////////////////////////////////
//	GRAPH
//////////////////////////////////////////////////////////////////////////

function	graph_rrd($opt,$gtype)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$type_tbl = array(
		"hour"  => array("START" => -60*60       ),
		"day"   => array("START" => -60*60*24    ),
		"week"  => array("START" => -60*60*24*7  ),
		"month" => array("START" => -60*60*24*31 ),
		"year"  => array("START" => -60*60*24*365),
	);
	if ( ! isset($type_tbl[$gtype]) )
		return;
	$gt = $type_tbl[$gtype];

	$coltbl = array(
		"#EE0000",
		"#00EEEE",
		"#00EE00",
		"#EE00EE",
		"#EEEE00",
		"#990000",
		"#009999",
		"#009900",
		"#990099",
		"#999900",
	);
	$colmax = count($coltbl);
	$coltag = array(
		"BACK"   => "#000000",
		"CANVAS" => "#000000",
		"SHADEA" => "#000000",
		"SHADEB" => "#000000",
		"GRID"   => "#A0A0F0",
		"MGRID"  => "#8080C0",
		"FONT"   => "#D0D0D0",
		"FRAME"  => "#C0C0C0",
		"ARROW"  => "#C00000",
	);

	$tm = time();
	$tm_msg = date("Y-m-d H:i:s", $tm);
	for ( $di = 0; $di < count($smart_devs); $di++ )
	{
		$dev = $smart_devs[$di];
		if ( isset($opt["DEV"]) && $dev["DEV"] != $opt["DEV"] )
			continue;
		unset($gtbl);
		for ( $si = 0; $si < count($smart_tbl); $si++ )
		{
			$smart = $smart_tbl[$si];
			$group = $smart["GROUP"];
			if ( isset($opt["ID"]) && $smart["ID"] != $opt["ID"] )
				continue;
			if ( isset($opt["ID"]) == FALSE && $group == G_NONE )
				continue;
			if ( ! isset($gtbl[$group]["COUNT"]) )
				$gtbl[$group]["COUNT"] = 0;
			if ( $gtbl[$group]["PARAM"] == "" )
			{
				if ( isset($opt["ID"]) )
				{
					$title = "{$dev["DEV"]} - {$dev["MODEL"]} ID:{$smart["ID"]} ($gtype)";
					if ( isset($opt["VAL"]) )
						$gp = "{$smart_vals[$opt["VAL"]]}{$opt["ID"]}";
					else
						$gp = "{$smart_vals[$smart["VAL"]]}{$opt["ID"]}";
				} else
				{
					$title = "{$tm_msg} {$dev["DEV"]} - {$dev["MODEL"]} {$smart_groups[$group]["LABEL"]} ($gtype)";
					$gp = $group;
				}
				$gtbl[$group]["PARAM"] = GetGraphPath($dev, $gp, $gtype)
				 . " --title \"{$title}\""
				 . " --imgformat GIF"
				 . " --width "  . GRAPH_WIDTH
				 . " --height " . GRAPH_HEIGHT
				 . " --start {$gt["START"]}"
				;
				$ks_c = array_keys($coltag);
				for ( $ci = 0; $ci < count($ks_c); $ci++ )
					$gtbl[$group]["PARAM"] .= " --color {$ks_c[$ci]}{$coltag[$ks_c[$ci]]}";
				$gtbl[$group]["COLOR"] = 0;
			}
			$col_line = $coltbl[$gtbl[$group]["COLOR"]];
		//	$col_line = $coltbl[($smart["ID"]) % $colmax];
			$gtbl[$group]["PARAM"] .=  GetGraphParam($opt, array("LINE"=>$col_line), $dev, $smart);
			$gtbl[$group]["COLOR"] = ($gtbl[$group]["COLOR"] + 1 ) % $colmax;
			$gtbl[$group]["COUNT"]++;
		}

		$g_ks = array_keys($gtbl);
		for ( $i = 0; $i < count($g_ks); $i++ )
		{
			$group = $g_ks[$i];
			$cmd = RRDTOOL . " graph " . $gtbl[$group]["PARAM"];
			if ( $opt["PRINT"] != "OFF" )
				echo "GROUP {$group}: {$cmd} \n";
			system($cmd);
		}
	}
}
function	GetGraphParam($opt, $col, $dev, $smart)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$param = "";
	if ( isset($opt["VAL"]) )
		$val = $opt["VAL"];
	else
		$val = $smart["VAL"];
	$vname = "{$smart_vals[$val]}{$smart["ID"]}";
	$rrdpath = str_replace(":","\\:",GetRrdPath($dev));
	if ( $smart["ID"] == 9 && $val == V_RAW )	// hour => day
	{
		$vnameA = "{$vname}A";
		$vnameB = "{$vname}B";
		$param .=  " DEF:{$vnameA}=\"{$rrdpath}\":{$vname}:LAST";
		$param .=  " CDEF:{$vnameB}={$vnameA},24.0,/";
		$vname = $vnameB;
	} else
		$param .=  " DEF:{$vname}=\"{$rrdpath}\":{$vname}:LAST";
	$label = sprintf("%3d\\:", (int)$smart["ID"]) . "{$smart["LABEL"]} ({$smart_vals[$val]})";
//	$param .=  " LINE2:{$vname}{$col["LINE"]}:\"{$smart["LABEL"]} ({$smart_vals[$val]})\"";
	$param .=  " LINE2:{$vname}{$col["LINE"]}:\"{$label}\"";
	$param .=  " GPRINT:{$vname}:LAST:\"cur\:%6.1lf\"";
	$param .=  " GPRINT:{$vname}:MAX:\"max\:%6.1lf\"";
	$param .=  " GPRINT:{$vname}:MIN:\"min\:%6.1lf\"";
	$param .=  " GPRINT:{$vname}:AVERAGE:\"ave\:%6.1lf\\n\"";

	return $param;
}

//////////////////////////////////////////////////////////////////////////
//	OUTPUT HTML (for Windows)
//////////////////////////////////////////////////////////////////////////

function	print_html($opt)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$time_type = array("day","month","year");

	$graph_file = GRAPHDIR . "/graph.htm";
	if ( ($fp = fopen($graph_file,"w")) == FALSE )
		return;
	fputs($fp,"<HTML>\n");
	fputs($fp,"<BODY>\n");
	$tm = time();
	$msg = "<B>".date("Y-m-d H:i:s", $tm)."</B><BR>\n";
	fputs($fp, $msg);
	fputs($fp, "<CENTER>\n");
	for ( $ti = 0; $ti < count($time_type); $ti++ )
	{
		$gtype = $time_type[$ti];
		fputs($fp, "<HR>\n");
		fputs($fp, "<FONT SIZE=\"+2\">{$gtype}</FONT><BR>\n");
		graph_rrd(array("PRINT"=>"OFF"), $gtype);

		$ks_g = array_keys($smart_groups); 
		for ( $gi = 0; $gi < count($ks_g); $gi++ )
		{
			$group = $ks_g[$gi];
		//	echo "{$group}\n";
			for ( $di = 0; $di < count($smart_devs); $di++ )
			{
				$dev = $smart_devs[$di];

				$imgsrc = GetGraphFileName($dev, $group, $gtype);
			//	$imgsrc = GetGraphPath($dev, $group, $gtype);
				$msg = "<BR>\n"
				     . date("Y-m-d H:i:s", $tm)
				     . " ({$gtype}) - {$dev["DEV"]} <B>{$dev["MODEL"]}</B>"
				     . " <FONT SIZE=\"+1\">{$smart_groups[$group]["LABEL"]}</FONT><BR>\n";
				fputs($fp, $msg);
			//	echo "{$imgsrc}\n";
				fputs($fp, "<IMG SRC=\"{$imgsrc}\"> <BR>\n");
			}
		}
		fputs($fp, "<BR>\n");
	}
	fputs($fp, "</CENTER>\n");
	fputs($fp,"</BODY>\n");
	fputs($fp,"</HTML>\n");
	fclose($fp);

	if ( HTMLBROWS != "" )
	{
		$cmd = HTMLBROWS . " {$graph_file}";
		echo $cmd;
		system($cmd);
	}

	return;
}

//////////////////////////////////////////////////////////////////////////
//	TUNE
//////////////////////////////////////////////////////////////////////////

function	tune_rrd($opt)
{
	global	$smart_vals, $smart_groups, $smart_tbl, $smart_devs;

	$tm = time();
	for ( $di = 0; $di < count($smart_devs); $di++ )
	{
		$dev = $smart_devs[$di];
		$param = GetRrdPath($dev);
		for ( $si = 0; $si < count($smart_tbl); $si++ )
		{
			$smart = $smart_tbl[$si];
			$ks_v = array_keys($smart_vals);
			for ( $vi = 0; $vi < count($ks_v); $vi++ )
			{
				$vtype = $ks_v[$vi];
				$cmd = "--heartbeat {$smart_vals[$vtype]}{$smart["ID"]}:".HEARTBEAT;
				$param .= " {$cmd}";
			}
		}

		$cmd = RRDTOOL . " tune {$param}";
		echo "{$cmd} \n";
		system($cmd);
	}
	return;
}
